// Boite.cpp : implementation file
//

#include "stdafx.h"
#include "client.h"
#include "grt.h"
#include "Boite.h"
#include "CSink.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

UINT GRAFITISTMFORMATDATA = RegisterClipboardFormat(_T("GRAFITISTMFORMATDATA"));

/////////////////////////////////////////////////////////////////////////////
// CBoite dialog


CBoite::CBoite(CWnd* pParent /*=NULL*/)
	: CDialog(CBoite::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBoite)
	m_lecture = FALSE;
	m_equip = _T("MASTER");
	m_repere = _T("%MW0");
	m_valeur = _T("");
	m_bReadCont = FALSE;
	m_NbAdv = 0;
	m_NbSec = 0;
	//}}AFX_DATA_INIT
}


void CBoite::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBoite)
	DDX_Control(pDX, IDC_READVAL, m_readval);
	DDX_Control(pDX, IDC_TNBSEC, m_cTNbSec);
	DDX_Control(pDX, IDC_STOP, m_stop);
	DDX_Control(pDX, IDC_SEND, m_send);
	DDX_Check(pDX, IDC_CHECK1, m_lecture);
	DDX_Text(pDX, IDC_EQUIP, m_equip);
	DDX_Text(pDX, IDC_REP, m_repere);
	DDX_Text(pDX, IDC_VAL, m_valeur);
	DDX_Check(pDX, IDC_READCONT, m_bReadCont);
	DDX_Text(pDX, IDC_NBADV, m_NbAdv);
	DDX_Text(pDX, IDC_NBSEC, m_NbSec);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBoite, CDialog)
	//{{AFX_MSG_MAP(CBoite)
	ON_BN_CLICKED(IDC_SEND, OnSend)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBoite message handlers

void CBoite::OnSend() 
{
VARIANT v;
char buf[33];
char *p;
long rc;
long i;
	AfxVariantInit(&v);
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if (m_lecture && !m_bReadCont) // lecture unitaire
	{
		for (i = 0; i<=m_NbAdv; i++)
		{
		 m_pSinkTest->ReadVariable((LPCTSTR) m_equip, (LPCTSTR) m_repere, &v, &rc);
		 if (rc == 0)
		 {
		  if (v.vt == VT_I2 || v.vt == VT_I4)
			itoa(v.iVal, buf, 10);
		  if (v.vt == VT_BSTR)
		  {
			p = (char *) (v.bstrVal);
			wcstombs(buf, v.bstrVal, 32);
		  }
		  CString cs(buf);
		  m_readval.SetWindowText(buf);
		  m_valeur=cs;
		 }
		 else m_valeur = "??";
		 UpdateData(FALSE);
		}
		Beep(200, 200);
	}


	if (m_lecture && m_bReadCont) // lecture continue
	{
		m_send.EnableWindow(FALSE); // griser CButton
		m_stop.EnableWindow(TRUE);
		InitReadContinue();
		UpdateData(FALSE);
	}

	if (!m_lecture && !m_bReadCont) // Ecriture
	{
		// mettre la valeur a ecrire dans un variant *
		if (m_valeur == "") 
		{
			Beep(200,200);
			return;
		}
		v.vt = VT_I2;
		v.iVal= atoi(m_valeur.GetBuffer(9));
		for (i = 0; i<=m_NbAdv; i++)
			m_pSinkTest->WriteVariable((LPCTSTR) m_equip, (LPCTSTR) m_repere, &v, &rc);
		if (rc == 0) m_valeur=m_valeur+"!!";
		else  m_valeur="??"+m_valeur+"??";
		UpdateData(FALSE);
	}
}

void CBoite::OnStop() 
{
long rc;
	// TODO: Add your control notification handler code here
		m_send.EnableWindow(TRUE); // griser CButton
		m_stop.EnableWindow(FALSE);
	
	// Fermeture de la connexion du client avec le serveur
	// Le client ne sera plus notifier des modifications des donnees
	// du serveur
		m_pSinkTest->StopReadContinue(m_h, &rc);
		m_h = 0;
	m_dataObj->DUnadvise(m_dwCookie);

	// m_adviseSink->Release();deja released
	m_dataObj->Release();
}


long CBoite::InitReadContinue()
{
long rc;
	FORMATETC	 fmt; /* = {CF_BITMAP, NULL, DVASPECT_CONTENT, -1, TYMED_GDI};*/
	fmt.cfFormat = GRAFITISTMFORMATDATA;
	fmt.tymed    = TYMED_HGLOBAL;
	fmt.ptd      = NULL;
	fmt.dwAspect = DVASPECT_CONTENT;
	fmt.lindex   = -1;

	// Cration d'une classe CAdviseSink qui implmente l'interface
	// IAdvise du client MFC
	// On se demande notre propre interface, pour la passer au serveur
	CAdviseSink* advise = new CAdviseSink(); 
	HRESULT hr = advise->QueryInterface(IID_IAdviseSink, (PVOID*)&m_adviseSink);
	_ASSERT(SUCCEEDED(hr) && m_adviseSink);
	advise->m_pBoite = this; // on lui passe this, pour qu'il ecrive dedans

	// Appel de la mthode QueryInterface par Automation pour
	// rcuprer l'interface IDataObject du serveur automation ATL
	hr = (m_pSinkTest->m_lpDispatch)->QueryInterface(IID_IDataObject, (PVOID*)&m_dataObj);
	_ASSERT(SUCCEEDED(hr) && m_dataObj);

	// Appel de la mthode DAdvise de l'interface IDataObject du serveur ATL
	// pour lui dire que le client veut tre notifie des modifications des donnees
	// On lui passe en paramtre le pointer sur l'interface IAdvise du client afin
	// que le serveur puisse l'appeller
	hr = m_dataObj->DAdvise(&fmt, 0, m_adviseSink, &m_dwCookie);
	_ASSERT(SUCCEEDED(hr));

	m_adviseSink->Release(); // plus besoin de lui apres le DAdvise

	// Appel de readVariableContinue et ActiveReadContinue, qui
	// provoqueront l'appel de la mthode OnDataChange
	// de l'interface IAdvise du client (Csink.cpp)

	// Il faut lui passer des tableaux de chaines sous forme de variant !!!
	SAFEARRAYBOUND sabound[1];  // nombre de colonnes du tableau
    SAFEARRAY FAR* psaEquip = NULL;  // initialisation du tableau
    SAFEARRAY FAR* psaRepere = NULL;   // initialisation du tableau
	VARIANT v_equip, v_repere;
	AfxVariantInit(&v_equip);
	AfxVariantInit(&v_repere);
	V_VT(&v_equip) = VT_BSTR | VT_ARRAY |VT_BYREF;
	V_VT(&v_repere) = VT_BSTR | VT_ARRAY | VT_BYREF;
	BSTR bstrequip, bstrrepere;

	//initialisation du nombre d'elements
	sabound[0].cElements = 1; 
	sabound[0].lLbound = 0;

	// Creation des safe Arrays
	psaEquip = SafeArrayCreate(VT_BSTR, 1, sabound);
	if (psaEquip == NULL)
    return E_FAIL;	
	psaRepere = SafeArrayCreate(VT_BSTR, 1, sabound);
	if (psaRepere == NULL)
    return E_FAIL;

	// mise des chaines dans les safearrays
	long index = 0;
	bstrequip = m_equip.AllocSysString();
	hr = SafeArrayPutElement(psaEquip, &index, bstrequip);
	if (hr != S_OK) return -1;
	SysFreeString (bstrequip);
	bstrrepere = m_repere.AllocSysString();
	hr = SafeArrayPutElement(psaRepere, &index, bstrrepere);
	if (hr != S_OK) return -1;
	SysFreeString (bstrrepere);


	// on peut ecrire ds les variant
	/*
    V_ARRAY(&v_equip) = psaEquip;
    V_ARRAY(&v_repere) = psaRepere;
	*/
	v_equip.pparray = &psaEquip;
	v_repere.pparray = &psaRepere;


	m_pSinkTest->ReadVariableContinue(v_equip, v_repere, (short)m_NbSec, &m_h, &rc);

	m_pSinkTest->ActiveReadContinue(m_h, &rc);
	return(0);

	// safearraydestroy ??
	// maintenant, c'est OnDataChange qui bosse...
}

BOOL CBoite::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	if (m_lecture && !m_bReadCont) // lecture unitaire
	{
		m_send.SetWindowText("Lecture Unitaire");
		m_cTNbSec.EnableWindow(FALSE);
		GetDlgItem(IDC_NBSEC)->EnableWindow(FALSE);
	}
	if (m_lecture && m_bReadCont) // lecture continue
	{
		m_send.SetWindowText("Lecture Continue");
		m_cTNbSec.EnableWindow(TRUE);
		GetDlgItem(IDC_NBSEC)->EnableWindow(TRUE);
	}
	if (!m_lecture && !m_bReadCont) // Ecriture
	{
		m_send.SetWindowText("Ecriture");
		m_cTNbSec.EnableWindow(FALSE);
		GetDlgItem(IDC_NBSEC)->EnableWindow(FALSE);
	}
	m_send.SetFocus();
	m_NbAdv = 0;
	
	return FALSE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
